//
//  FJDIndexedItemsArrayController.m
//  FJDIndexedItemsWindow
//
//  Created by FUJIDANA on 06/08/22.
//  Copyright 2006 FUJIDANA. All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions
// are met:
// 1. Redistributions of source code must retain the above copyright
//    notice, this list of conditions and the following disclaimer.
// 2. Redistributions in binary form must reproduce the above copyright
//    notice, this list of conditions and the following disclaimer in the
//    documentation and/or other materials provided with the distribution.
//
// THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
// IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
// OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
// IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
// INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
// NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
// DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
// THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
// (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
// THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.


#import "FJDIndexedItemsArrayController.h"


@implementation FJDIndexedItemsArrayController

#pragma mark Accessor methods

- (NSManagedObject *)indexManager
{
	return _indexManager;
}

- (void)setIndexManager:(NSManagedObject *)value
{
	if (_indexManager != value) {
		[_indexManager release];
		_indexManager = [value retain];
	}
}

- (void)dealloc
{
	[self setIndexManager:nil];
	
	[super dealloc];
}

#pragma mark Overriding superclass

- (void)insertObject:(id)object atArrangedObjectIndex:(unsigned int)index
{
    [super insertObject:object atArrangedObjectIndex:index];
	
	int unusedIndex = [self unusedIndex];
	if (unusedIndex != NSNotFound) {
		[object setValue:[NSNumber numberWithInt:unusedIndex] forKey:@"index"];
	}
	
	[object setValue:[self indexManager] forKey:@"indexManager"];
}

- (void)insertObjects:(NSArray *)objects atArrangedObjectIndexes:(NSIndexSet *)indexes
{
	[super insertObjects:objects atArrangedObjectIndexes:indexes];
	
	NSEnumerator *enumerator = [objects objectEnumerator];
	NSManagedObject *object;
	
	while (object = [enumerator nextObject]) {
		int unusedIndex = [self unusedIndex];
		if (unusedIndex != NSNotFound) {
			[object setValue:[NSNumber numberWithInt:unusedIndex] forKey:@"index"];
		}
		[object setValue:[self indexManager] forKey:@"indexManager"];
	}
}

#pragma mark Auxiliary methods

- (int)unusedIndex
{
	return [self unusedIndexExceptItems:nil];
}

- (int)unusedIndexExceptItems:(NSSet *)exceptedItems
{
	NSSet *itemsSet = [[self indexManager] valueForKey:@"items"];
	
	if (exceptedItems) {
		NSMutableSet *subset = [[itemsSet mutableCopy] autorelease];
		[subset minusSet:exceptedItems];
		itemsSet = subset;
	}
	
	if ([itemsSet count] == 0) {
		return 0;
	}
	
	NSSortDescriptor *sortDescriptor = [[[NSSortDescriptor alloc] initWithKey:@"index" ascending:YES] autorelease];
	NSArray	*itemsArray = [[itemsSet allObjects] sortedArrayUsingDescriptors:[NSArray arrayWithObject:sortDescriptor]];
	
	NSEnumerator *enumerator = [itemsArray objectEnumerator];
	NSManagedObject *item;
	int i = 0;
	while (item = [enumerator nextObject]) {
		
//		if (exceptedItems && [exceptedItems containsObject:item]) {
//			continue;
//		}
		
		int currentIndex = [[item valueForKey:@"index"] intValue];
		if (currentIndex < i) {
			continue;
		} else if (currentIndex > i) {
			return i;
		}
		i++;
	}
	
	int lastIndex = [[[itemsArray lastObject] valueForKey:@"index"] intValue];
	return lastIndex + 1;
}

//- (int)unusedIndexAboveIndex:(int)lowestIndex exceptObjects:(NSArray *)exceptedObjects
//{
////	NSSortDescriptor	*sortDescriptor		= [[[NSSortDescriptor alloc] initWithKey:@"index" ascending:YES] autorelease];
////	NSArray				*sortDescriptors	= [NSArray arrayWithObject:sortDescriptor];
////	NSMutableArray		*contentArray		= [[[self content] mutableCopy] autorelease];
////	
////	if (exceptedObjects != nil) {
////		[contentArray removeObjectsInArray:exceptedObjects]; 
////	}
////	NSArray				*sortedArray	= [contentArray sortedArrayUsingDescriptors:sortDescriptors];
////	
////	NSNumber			*indexWrapper;
////	int					currentIndex	= lowestIndex;
////	int					i;
////	
////	int					n				= [sortedArray count];
////	// -- set 'n' to the index of the content array which becomes greater than or equal to 'lowestIndex' --
////	for (i = 0; i < [sortedArray count]; i++) {
////		indexWrapper = [[sortedArray objectAtIndex:i] valueForKey:@"index"];
////		if (indexWrapper != nil && [indexWrapper intValue] >= lowestIndex) {
////			n = i;
////			break;
////		}
////	}
////	
////	// return the lowest unused index between 'n'th card's index ('lowestIndex') and the largest index in existence, if it exists.
////	for (i = n; i < [sortedArray count]; i++) {
////		indexWrapper = [[sortedArray objectAtIndex:i] valueForKey:@"index"];
////		if (indexWrapper != nil && [indexWrapper intValue] != currentIndex) {
////			return currentIndex;
////		}
////		currentIndex++;
////	}
////	
////	// return the lowest unused index above the largest index in existence, if it exists.
////	if (currentIndex <= [self maxValue]) {
////		return currentIndex;
////	}
////	
////	currentIndex = [self minValue];
////	
////	// return the lowest unused index below 'n-1'th card's index, if it exists.
////	for (i = [self minValue]; i < n; i++) {
////		indexWrapper = [[sortedArray objectAtIndex:i] valueForKey:@"index"];
////		if (indexWrapper != nil && [indexWrapper intValue] != currentIndex) {
////			return currentIndex;
////		}
////		currentIndex++;
////	}
////	
////	// return the lowest numbmer between 'n-1'th card's index and 'n'th card's inex ('lowestIndex'), if it exists.
////	if (currentIndex != lowestIndex) {
////		return currentIndex;
////	}
////	
////	// fail to find an unused memory index.
////	return NSNotFound;
//}
//

@end